<?php
/*--------------------------------------------------------------
   Item.php 2021-06-02
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Map;

use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Map\Item\Title;
use Gambio\Admin\Modules\Statistics\Model\ValueObjects\Data\Map\Item\Value;

class Item
{
    /**
     * @var Title
     */
    private $title;
    
    /**
     * @var Value
     */
    private $value;
    
    
    /**
     * Constructor.
     */
    private function __construct(Title $title, Value $value)
    {
        $this->title = $title;
        $this->value = $value;
    }
    
    
    /**
     * Create instance.
     */
    public static function create(Title $title, Value $value): self
    {
        return new self($title, $value);
    }
    
    
    /**
     * Return title.
     */
    public function title(): Title
    {
        return $this->title;
    }
    
    
    /**
     * Return value.
     */
    public function value(): Value
    {
        return $this->value;
    }
}